#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Breathing MAE IllusionMod01.fsh   by  SirShart  
//https://www.shadertoy.com/view/McjBzc
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159265359

// Function to create a crystalline pattern
float crystalPattern(vec2 uv, float time) {
    float scale = 8.0;
    uv *= scale;

    // Crystal growth pattern based on distance and time
    float angle = atan(uv.y, uv.x);
    float radius = length(uv);
    
    float crystal = cos(radius * 12.0 - time * 4.0) + sin(angle * 8.0 + time * 3.0);
    crystal = pow(abs(crystal), 2.0);  // Sharpen the crystalline edges
    
    return crystal;
}

// Function to create chromatic aberration effect
vec3 chromaticAberration(vec2 uv, float time) {
    float crystalR = crystalPattern(uv + vec2(0.01, 0.0), time);
    float crystalG = crystalPattern(uv, time);
    float crystalB = crystalPattern(uv - vec2(0.01, 0.0), time);

    return vec3(crystalR, crystalG, crystalB);
}

// Function to add dynamic pulsing effect
float pulseEffect(float crystal, float time) {
    return crystal * (0.7 + 0.3 * sin(time * 5.0));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalize and center coordinates
    vec2 uv = fragCoord.xy / iResolution.xy;
    uv -= 0.5;
    uv.x *= iResolution.x / iResolution.y;
    
    // Apply time-based scaling to enhance the crystal's growth effect
    float time = iTime * 0.6;
    uv *= 1.0 + 0.2 * sin(time * 2.0);
    
    // Generate chromatic aberration effect for the crystal pattern
    vec3 crystalColor = chromaticAberration(uv, time);
    
    // Apply pulse effect to create a pulsating crystal formation
    crystalColor *= pulseEffect(crystalColor.g, time);
    
    // Output final color
    fragColor = vec4(crystalColor, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

